<?php
/*
                         ''~``
                        ( o o )
+------------------.oooO--(_)--Oooo.------------------+
|                    Unreal Portal                    |
|                    .oooO                            |
|                    (   )   Oooo.                    |
+---------------------\ (----(   )--------------------+
                       \_)    ) /
                             (_/


           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
           |The Logo Looks Best in Courier New|
           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

                       ---====---
                      Unreal Portal
                       By Cricket
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_uportal_uportal_uportal extends ipsCommand
{
	private $output        = "";
	private $blocks        = array();
	private $globals       = array();
	private $data          = array();

	private $topboxes      = "";
	private $leftboxes     = "";
	private $middleboxes   = "";
	private $rightboxes    = "";
	private $bottomboxes   = "";

	private $latest_posts  = array();
	private $latest_news   = array();
	private $news          = array();
	private $top_forums    = array();
	private $top_posters   = array();
	private $new_members   = array();

	private $width;

	private $forumid;

	public function doExecute( ipsRegistry $registry )
	{
        $this->registry->class_localization->loadLanguageFile( array( 'public_login' ), 'core' );
        $this->registry->class_localization->loadLanguageFile( array( 'public_topic' ), 'forums' );
        $this->registry->class_localization->loadLanguageFile( array( 'public_boards' ), 'forums' );
	    $this->registry->class_localization->loadLanguageFile( array( 'public_uportal' ) );

	    $this->initializeParser();

        $this->getSettings();
	    $this->getBlocks();
	    $this->getCustomBlocks();
	    $this->getCustomContent();

        $this->manageWidths();

	    $this->queryForData();
	    $this->buildBlocks();
	    $this->displayBlocks();

		$this->_do_output();
	}

    protected function _do_output()
    {
        //Top Column Start
        $this->output .= $this->topboxes;
        //Top Column End

        $this->output .= $this->portal_start();

        //Left Column Start
        $this->output .= $this->column_start($this->globals['setting']['left']);

        $this->output .= $this->leftboxes;

        $this->output .= $this->column_end();
        //Left Column End

        //Spacer Column
        $this->output .= $this->column_start($this->globals['setting']['spacer1']);
        $this->output .= $this->no_content();
        $this->output .= $this->column_end();

        //Middle Column Start
        $this->output .= $this->column_start($this->globals['setting']['middle']);

        $this->output .= $this->middleboxes;

        $this->output .= $this->column_end();
        //Middle Column End

        //Spacer Column
        $this->output .= $this->column_start($this->globals['setting']['spacer2']);
        $this->output .= $this->no_content();
        $this->output .= $this->column_end();

        //Right Column Start
        $this->output .= $this->column_start($this->globals['setting']['right']);

        $this->output .= $this->rightboxes;

        $this->output .= $this->column_end();

        $this->output .= $this->portal_end();

        //Bottom Column Start
        $this->output .= $this->bottomboxes;
        //Bottom Column End
        
        $output = base64_decode('PGRpdiBhbGlnbj0nY2VudGVyJz5Qb3dlcmVkIGJ5IFVucmVhbCBQ
            b3J0YWwgdjMuMC4yICZjb3B5OyAyMDExIDxhIGhyZWY9J2h0dHA6Ly93d3cudW5yZWFsLXN
            vbHV0aW9ucy5vcmcnIHRhcmdldD0nX2JsYW5rJz5VbnJlYWwgU29sdXRpb25zPC9hPjwvZ
            Gl2Pg==');

        $this->output .= $output;

        $this->registry->output->addContent( $this->output );
        $this->registry->output->setTitle( "{$this->settings['board_name']} - {$this->lang->words['page_title']}" );
        $this->registry->output->addNavigation( $this->lang->words['page_title'], 'app=uportal' );

        $this->registry->output->sendOutput();
    }

    private function initializeParser()
    {
        IPSText::getTextClass('bbcode')->allow_update_caches = 1;
        IPSText::getTextClass('bbcode')->bypass_badwords = intval($this->memberData['g_bypass_badwords']);
        IPSText::getTextClass('bbcode')->parse_smilies  = 1;
        IPSText::getTextClass('bbcode')->parse_html = 1;
        IPSText::getTextClass('bbcode')->parse_bbcode = 1;
    }

    private function getSettings()
    {
        $this->checkCache('up_settings', 'uportal_settings');

        if( is_array( $this->registry->cache()->getCache('uportal_settings') ) )
        {
            foreach($this->registry->cache()->getCache('uportal_settings') as $fetch)
            {
                $this->globals['setting'][$fetch['name']] = $fetch['value'];
            }
        }
    }

	private function getBlocks()
	{
	    $this->checkCache('unrealportal', 'uportal_blocks', 'order2 asc');

	    if( is_array( $this->registry->cache()->getCache('uportal_blocks') ) )
	    {
    	    foreach($this->registry->cache()->getCache('uportal_blocks') as $fetch)
    	    {
    	        if($fetch['custblock_id'] == 0)
    	        {
                    $this->globals['block'][$fetch['name']] = $fetch['show'];
                    $this->globals['block_ids'][$fetch['name']] = $fetch['id'];
                    $this->blocks[$fetch['name']] = $fetch['align'];
    	        }
    	        else
    	        {
                    $this->globals['block']["cb_{$fetch['custblock_id']}"] = $fetch['show'];
                    $this->globals['block_ids']["cb_{$fetch['custblock_id']}"] = $fetch['id'];
                    $this->blocks["cb_{$fetch['custblock_id']}"] = $fetch['align'];
    	        }
    	    }
	    }
	}

    private function getCustomBlocks()
    {
        $this->checkCache('up_custblocks', 'uportal_custblocks');

        if( is_array( $this->registry->cache()->getCache('uportal_custblocks') ) )
        {
            foreach($this->registry->cache()->getCache('uportal_custblocks') as $fetch)
            {
                $this->data["cb_{$fetch['id']}"] = $this->customBlock($fetch);
            }
        }
    }

    private function getCustomContent()
    {
        $content = array();
        $this->checkCache('up_custcontent', 'uportal_content');

        if( is_array( $this->registry->cache()->getCache('uportal_content') ) )
        {
            foreach($this->registry->cache()->getCache('uportal_content') as $fetch)
            {
                if($fetch['id'] == $this->request['code'])
                {
                    $content = $fetch;
                    break;
                }
            }

            if(sizeof($content) > 0)
                $this->data["cc_{$content['id']}"] = $this->content($content['id'], $content['name'], $content['title'], $content['html']);
        }
    }

    private function queryForData()
    {
        //Latest Posts

        if (($this->globals['block']['latest_posts_big'] != 0) || ($this->globals['block']['latest_posts']) != 0)
        {
            if ($this->globals['setting']['num_latestposts'])
                $number_of_posts1 = $this->globals['setting']['num_latestposts'];
            else
                $number_of_posts1 = 5;

            if ($this->globals['setting']['num_latestposts_big'])
                $number_of_posts2 = $this->globals['setting']['num_latestposts_big'];
            else
                $number_of_posts2 = 5;

            if($number_of_posts1 > $number_of_posts2)
                $maxcount = $number_of_posts1;
            else
                $maxcount = $number_of_posts2;

            $count = 0;

            $limit = $maxcount + 20;

            $where = "t.approved = '1'";
            if($this->memberData['is_mod'])
                $where = "1=1";

            $this->DB->build( array(
                'select'    => 't.tid, t.title, t.title_seo, t.description, t.state, t.poll_state, t.posts as replies, t.last_post, t.last_vote, t.start_date, t.views, t.starter_name as guest_starter_name, t.last_poster_name as guest_last_poster_name, t.seo_last_name as guest_seo_last_name, t.seo_first_name as guest_seo_first_name',
                'from'      => array( 'topics' => 't' ),
                'where'     => $where,
                'order'     => 't.last_post desc',
                'limit'     => array( $limit ),
                'add_join'  => array(
                                        array( 'select' => 'm.member_id as id, m.members_display_name, m.members_seo_name as seo_members_display_name',
                                                'from'  => array( 'members' => 'm' ),
                                                'where' => 'm.member_id=t.last_poster_id',
                                                'type'  => 'left'
                                        ),
                                        array( 'select' => 's.member_id as starter_id, s.members_display_name as starter_name, s.members_seo_name as seo_starter_name',
                                                'from'  => array( 'members' => 's' ),
                                                'where' => 's.member_id=t.starter_id',
                                                'type'  => 'left'
                                        ),
                                        array( 'select' => 'f.name, f.name_seo, f.id as forum_id',
                                                'from'  => array( 'forums' => 'f' ),
                                                'where' => 'f.id=t.forum_id',
                                                'type'  => 'left'
                                        )
                                    )
                ));

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
            {
                if(  $this->registry->permissions->check( 'read', $this->registry->getClass('class_forums')->forum_by_id[$fetch['forum_id'] ] ) !== false )
                {
                    $this->latest_posts[] = $fetch;
                    $count++;
                }

                if($count == $maxcount)
                    break;
            }
        }

        //End Latest Posts

        //Latest News

        if($this->globals['block']['latest_news'] != 0)
        {
            if($this->forumid == null)
            {
                // nothing inserted?
                if ( $this->globals['setting']['newsforum'] == "" )
                {
                    $this->forumid[]=1;
                }

                // multiple forums
                elseif ( $this->globals['setting']['newsforum'] == 0 )
                {
                    if ( $this->globals['setting']['newsforum_expert'] == "" )
                    {
                        if($this->globals['setting']['newsforum'] != null)
                            $this->forumid[]= $this->globals['setting']['newsforum'];
                        else
                            $this->forumid[]="1";
                    }
                    else
                    {
                        $this->forumid = explode(",", $this->globals['setting']['newsforum_expert']);
                    }
                }

                // normal
                else
                {
                    $this->forumid[] = $this->globals['setting']['newsforum'];
                }
            }

            $max = $this->globals['setting']['num_latest_news'];
            $total = sizeof($this->forumid);
            $count = 0;

            $this->width = 100 / $total;
            $this->width = floor($this->width);
            $this->width = "{$this->width}%";
            $toquery = "";

            if(is_array($this->forumid))
            {
                foreach($this->forumid as $key=>$value)
                {
                    $count++;
                    $toquery .= "(select f.name, f.id, t.tid, t.title, t.title_seo from {$this->DB->obj['sql_tbl_prefix']}topics t left join {$this->DB->obj['sql_tbl_prefix']}forums f on (f.id=t.forum_id) where t.forum_id = '$value'";

                    if ( ! $this->memberData['is_mod'] )
                        $toquery .= " and t.approved = '1'";

                    $toquery .= " order by t.tid desc limit $max)";

                    if($count != $total)
                        $toquery .= " union ";
                }
            }

            $this->DB->allow_sub_select = 1;

            $query = $this->DB->query($toquery);

            while($fetch = $this->DB->fetch($query))
            {
                if(  $this->registry->permissions->check( 'read', $this->registry->getClass('class_forums')->forum_by_id[$fetch['id'] ] ) !== false )
                {
                    $this->latest_news[] = $fetch;
                }
            }

            $this->DB->allow_sub_select = 0;
        }

        //End Latest News

        //News

        if($this->globals['block']['news'] != 0)
        {
            $count = 0;
            $max = $this->globals['setting']['newsposts'] ? $this->globals['setting']['newsposts'] : 5;

            if($this->globals['setting']['newsforum_expert'] != null)
                $this->forumid = explode(",", $this->globals['setting']['newsforum_expert']);
            else
                $this->forumid[] = $this->globals['setting']['newsforum'];

            // nothing inserted?
            if ( $this->globals['setting']['newsforum'] == "" and
            $this->globals['setting']['newsforum_expert'] == null )
            {
                $forumid="t.forum_id=2";
            }

            // multiple forums
            elseif ( $this->globals['setting']['newsforum_expert'] != null )
            {
                if ( $this->globals['setting']['newsforum_expert'] == "" )
                {
                    $forumid="t.forum_id=2";
                }
                else
                {
                    $forums = explode(",", $this->globals['setting']['newsforum_expert']);
                    $forumid = "t.forum_id=". join (" OR t.forum_id=", $forums);
                    // 'special' mode
                    $special = 1;
                }
            }
            // normal
            else
            {
                $forumid = "t.forum_id=". $this->globals['setting']['newsforum'];
            }

            // Selected Forum
            if($this->request['news'] != null)
            {
                $newsforum = $this->request['news'];

                if(is_array($this->forumid))
                {
                    foreach($this->forumid as $key => $value)
                    {
                        if($newsforum == $value)
                        {
                            $forumid = "t.forum_id=". $newsforum;
                            break;
                        }
                    }
                }
            }

            $limit = $maxcount + 20;

            $where = "({$forumid})";

            if( ! $this->memberData['is_mod'] )
                $where .= " and t.approved = '1'";

            $this->DB->build( array(
                'select'    => 't.forum_id, t.tid, t.title, t.title_seo, t.posts as comments, t.topic_hasattach',
                'from'      => array( 'topics' => 't' ),
                'where'     => $where,
                'order'     => "t.tid desc LIMIT {$limit}",
                'add_join'  => array(
                                        array( 'select' => 'p.pid, p.post_date, p.post, p.post_htmlstate, p.author_id, p.author_name',
                                                'from'  => array( 'posts' => 'p' ),
                                                'where' => 'p.topic_id=t.tid AND p.new_topic=1',
                                                'type'  => 'left'
                                        ),
                                        array( 'select' => 'm.members_display_name, m.members_seo_name, m.member_id as id, m.member_group_id as mgroup',
                                                'from'  => array( 'members' => 'm' ),
                                                'where' => 'm.member_id=p.author_id',
                                                'type'  => 'left'
                                        )
                                    )
                ));

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
            {
                if(  $this->registry->permissions->check( 'read', $this->registry->getClass('class_forums')->forum_by_id[$fetch['forum_id'] ] ) !== false )
                {
                    $this->news[] = $fetch;
                    $count++;
                }

                if($count == $max)
                    break;
            }
        }

        //End News

        //Top Forums

        if ($this->globals['block']['top_forums'] != 0)
        {
            $count = 0;
            if ($this->globals['setting']['num_top_forums'])
                $number_of_forums = $this->globals['setting']['num_top_forums'];
            else
                $number_of_forums = 5;

            $this->DB->build( array(
                'select'    => 'id, name, name_seo, topics, posts as replies',
                'from'      => 'forums',
                'where'     => 'sub_can_post = 1',
                'order'     => "topics desc, posts desc"
                ));

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
            {
                if(  $this->registry->permissions->check( 'read', $this->registry->getClass('class_forums')->forum_by_id[$fetch['id'] ] ) !== false )
                {
                    $this->top_forums[] = $fetch;
                    $count++;
                }

                if($count == $number_of_forums)
                    break;
            }
        }

        //End Top Forums

        if ($this->globals['block']['top_posters'] != 0)
        {
            if ($this->globals['setting']['num_topposters'])
                $number_top_posters = $this->globals['setting']['num_topposters'];
            else
                $number_top_posters = 5;

            $this->DB->build( array(
                'select'    => 'member_id as id, members_display_name, members_seo_name, posts',
                'from'      => 'members',
                'order'     => "posts desc LIMIT {$number_top_posters}"
                ));

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
            {
                $this->top_posters[] = $fetch;
            }
        }

        //End Top Posters

        //New Members

        if($this->globals['block']['new_members'] != 0)
        {
            if ($this->globals['setting']['num_newmembers'])
                $number_new_members = $this->globals['setting']['num_newmembers'];
            else
                $number_new_members = 5;

            $this->DB->build( array(
                'select'    => 'member_id as id, members_display_name, members_seo_name, joined',
                'from'      => 'members',
                'order'     => "id desc limit {$number_new_members}"
                ));

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
            {
                $this->new_members[] = $fetch;
            }
        }

        //End New Members
    }

    private function manageWidths()
    {
        if($this->globals['setting']['left'] == null)
            $this->globals['setting']['left'] = "25%";

        if($this->globals['setting']['spacer1'] == null)
            $this->globals['setting']['spacer1'] = "1%";

        if($this->globals['setting']['middle'] == null)
            $this->globals['setting']['middle'] = "50%";
        else
        {
            $this->globals['setting']['middle'] = str_replace("%", "", $this->globals['setting']['middle']);

            if($this->globals['setting']['left'] != "0%")
                $this->globals['setting']['middle']--;

            if($this->globals['setting']['right'] != "0%")
                $this->globals['setting']['middle']--;

            $this->globals['setting']['middle'] = "{$this->globals['setting']['middle']}%";
        }

        if($this->globals['setting']['spacer2'] == null)
            $this->globals['setting']['spacer2'] = "1%";

        if($this->globals['setting']['right'] == null)
            $this->globals['setting']['right'] = "25%";

        if($this->globals['setting']['leftcustom'] == null)
            $this->globals['setting']['leftcustom'] = "25%";

        if($this->globals['setting']['middlecustom'] == null)
            $this->globals['setting']['middlecustom'] = "50%";
        else
        {
            $this->globals['setting']['middlecustom'] = str_replace("%", "", $this->globals['setting']['middlecustom']);

            if($this->globals['setting']['leftcustom'] != "0%")
                $this->globals['setting']['middlecustom']--;

            if($this->globals['setting']['rightcustom'] != "0%")
                $this->globals['setting']['middlecustom']--;

            $this->globals['setting']['middlecustom'] = "{$this->globals['setting']['middlecustom']}%";
        }

        if($this->globals['setting']['rightcustom'] == null)
            $this->globals['setting']['rightcustom'] = "25%";

        if($this->request['code'] != null)
        {
            $this->globals['setting']['left']     = $this->globals['setting']['leftcustom'];
            $this->globals['setting']['middle']   = $this->globals['setting']['middlecustom'];
            $this->globals['setting']['right']    = $this->globals['setting']['rightcustom'];
        }
    }

    private function buildBlocks()
    {
        $this->data['loginbox']         = $this->login();
        $this->data['latest_posts']     = $this->latest_posts();
        $this->data['stats']            = $this->board_stats();
        $this->data['calendar']         = $this->calendar();
        $this->data['custom_content']   = $this->customcontent();

        $this->data['latest_posts_big'] = $this->latest_posts_big();
        $this->data['latest_news']      = $this->latest_news();
        $this->data['news']             = $this->news();
        $this->data['poll']             = $this->poll();
        $this->data['top_forums']       = $this->top_forums();

        $this->data['top_posters']      = $this->top_posters();
        $this->data['new_members']      = $this->new_members();
    }

    private function displayBlocks()
    {
        if(is_array($this->blocks))
        {
            foreach($this->blocks as $fetch['name'] => $fetch['align'])
            {
                if($fetch['align'] == 'top')
                    $this->topboxes .= $this->data[$fetch['name']];

                if($this->globals['setting']['left'] == "0%" and $this->globals['setting']['right'] != "0%" and $this->request['code'] == null)
                {
                    if($fetch['align'] == 'left' or $fetch['align'] == 'right')
                        $this->rightboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                        $this->middleboxes .= $this->data[$fetch['name']];
                }
                else if($this->globals['setting']['right'] == "0%" and $this->globals['setting']['left'] != "0%" and $this->request['code'] == null)
                {
                    if($fetch['align'] == 'left' or $fetch['align'] == 'right')
                        $this->leftboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                        $this->middleboxes .= $this->data[$fetch['name']];
                }
                else if($this->globals['setting']['left'] == "0%" and $this->globals['setting']['right'] == "0%" and $this->request['code'] == null)
                {
                    if($fetch['align'] == 'middle')
                        $this->middleboxes .= $this->data[$fetch['name']];
                }
                else if($this->globals['setting']['left'] != "0%" and $this->globals['setting']['right'] != "0%" and $this->request['code'] == null)
                {
                    if($fetch['align'] == 'left')
                        $this->leftboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                        $this->middleboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'right')
                        $this->rightboxes .= $this->data[$fetch['name']];
                }

                else if($this->globals['setting']['leftcustom'] == "0%" and $this->globals['setting']['rightcustom'] != "0%" and $this->request['code'] != null)
                {
                    if($fetch['align'] == 'left' or $fetch['align'] == 'right')
                        $this->rightboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                    {
                        if($fetch['name'] == "news")
                        {
                            $this->middleboxes.= $this->data["cc_{$this->request['code']}"];
                        }
                        else
                            $this->middleboxes .= $this->data[$fetch['name']];
                    }
                }
                else if($this->globals['setting']['rightcustom'] == "0%" and $this->globals['setting']['leftcustom'] != "0%" and $this->request['code'] != null)
                {
                    if($fetch['align'] == 'left' or $fetch['align'] == 'right')
                        $this->leftboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                    {
                        if($fetch['name'] == "news")
                        {
                            $this->middleboxes.= $this->data["cc_{$this->request['code']}"];
                        }
                        else
                            $this->middleboxes .= $this->data[$fetch['name']];
                    }
                }
                else if($this->globals['setting']['leftcustom'] == "0%" and $this->globals['setting']['rightcustom'] == "0%" and $this->request['code'] != null)
                {
                    if($fetch['align'] == 'middle')
                    {
                        if($fetch['name'] == "news")
                        {
                            $this->middleboxes.= $this->data["cc_{$this->request['code']}"];
                        }
                        else
                            $this->middleboxes .= $this->data[$fetch['name']];
                    }
                }
                else if($this->globals['setting']['leftcustom'] != "0%" and $this->globals['setting']['rightcustom'] != "0%" and $this->request['code'] != null)
                {
                    if($fetch['align'] == 'left')
                        $this->leftboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'right')
                        $this->rightboxes .= $this->data[$fetch['name']];
                    else if($fetch['align'] == 'middle')
                    {
                        if($fetch['name'] == "news")
                        {
                            $this->middleboxes.= $this->data["cc_{$this->request['code']}"];
                        }
                        else
                            $this->middleboxes .= $this->data[$fetch['name']];
                    }
                }

                if($fetch['align'] == 'bottom')
                    $this->bottomboxes .= $this->data[$fetch['name']];
            }
        }
    }

    function login()
    {
        if ($this->globals['block']['loginbox'] && !$this->memberData['member_id'])
        {
            $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['loginbox'], "log_in");
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->login_start();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->login();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->login_end();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

            return $to_return;
        }
        return '';
    }

    function latest_posts()
    {
        $latest_posts = array();

        if(!($this->globals['block']['latest_posts']))
            return '';

        if(sizeof($this->latest_posts) > 0)
        {
            if ($this->globals['setting']['num_latestposts'])
                $maxcount = $this->globals['setting']['num_latestposts'];
            else
                $maxcount = 5;

            $count = 0;

            foreach($this->latest_posts as $key=>$fetch)
            {
                $latest_posts[] = $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->latest_posts_row($fetch);

                $count++;

                if($count == $maxcount)
                    break;
            }
        }

        $latest_posts = implode($this->registry->getClass('output')->getTemplate('uportal')->br(), $latest_posts);

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['latest_posts'], "latest_posts");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->general_block($latest_posts);
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function board_stats()
    {
        if(!($this->globals['block']['stats']))
            return '';

        require_once( IPSLib::getAppDir( 'forums', 'forums' ) . '/boards.php' );
        $boards = new public_forums_forums_boards();
        $boards->makeRegistryShortcuts( $this->registry );

        $active = $boards->getActiveUserDetails();
        $stats_info = $boards->getTotalTextString();

        $active = array_merge( $active, array(  'text'    => $this->lang->words['total_word_string'],
                                                'posts'   => $boards->total_posts,
                                                'active'  => $boards->users_online,
                                                'members' => $boards->total_members,
                                                'cut_off' => $this->settings['au_cutoff'],
                                                'info'    => $stats_info ) );

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['stats'], "board_stats");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->stats_header($active, $birthdays, $events, $this->globals['block_ids']['stats']);
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function calendar()
    {
        if (!($this->globals['block']['calendar']))
            return '';

        require_once( 'classes/class_calendar.php' );
        $this->class_calendar = new class_calendar( $this->registry );
        $this->class_calendar->globals =& $this->globals;

        return $this->class_calendar->show_calendar();
    }

    function customcontent()
    {
        if (!($this->globals['block']['custom_content']))
            return '';

        if( is_array( $this->registry->cache()->getCache('uportal_content') ) )
        {
            foreach($this->registry->cache()->getCache('uportal_content') as $fetch)
            {
                $links .= "<a href='{$this->settings['base_url']}app=uportal&amp;code={$fetch['id']}'>{$fetch['title']}</a><br/>";
            }
        }

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['custom_content'], "custom_content");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->general_block($links);
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function latest_posts_big()
    {
        if (!($this->globals['block']['latest_posts_big']))
            return '';

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['latest_posts_big'], "latest_posts_big");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start('header');
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->latest_posts_big_start();

        if(sizeof($this->latest_posts) > 0)
        {
            if ($this->globals['setting']['num_latestposts_big'])
                $maxcount = $this->globals['setting']['num_latestposts_big'];
            else
                $maxcount = 5;

            $count = 0;

            foreach($this->latest_posts as $key=>$fetch)
            {
                $fetch['start_date'] = $this->registry->class_localization->getDate( $fetch['start_date'], 'LONG');

                if($fetch['poll_state'] == 0)
                {
                    $fetch['last_action'] = $this->registry->class_localization->getDate( $fetch['last_post'], 'LONG');
                }
                else
                {
                    if($fetch['last_poll'] > $fetch['last_post'])
                        $fetch['last_action'] = $this->registry->class_localization->getDate( $fetch['last_poll'], 'LONG');
                    else
                        $fetch['last_action'] = $this->registry->class_localization->getDate( $fetch['last_post'], 'LONG');
                }

                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->latest_posts_big_row($fetch);

                $count++;

                if($count == $maxcount)
                    break;
            }
        }

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function latest_news()
    {
        if(!($this->globals['block']['latest_news']))
            return '';

        if(sizeof($this->latest_news) > 0)
        {
            $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['latest_news'], "latest_news");
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start("header");

            $forum_name = "";
            $count = -1;
            $count2 = 0;
            $maxcount = 0;

            $latest_news = array();

            foreach($this->latest_news as $key=>$fetch)
            {
                if($forum_name != $fetch['name'])
                {
                    $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->th_row($this->width, $fetch);
                    $forum_name = $fetch['name'];
                    $count++;

                    $count2 = 0;
                }
                $latest_news[$count][$count2] = $fetch;
                $count2++;

                if($count2 > $maxcount)
                    $maxcount = $count2;
            }

            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();

            for($count2 = 0; $count2 < $maxcount; $count2++)
            {
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start();

                for($newcount = 0; $newcount <= $count; $newcount++)
                {
                    $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->td_row($this->width, $latest_news[$newcount][$count2]);
                }

                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();
            }

            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

            return $to_return;
        }
    }

    function news()
    {
        if($this->globals['block']['news'] == 0)
            return '';

        if ( ! is_object( $this->class_attach ) )
        {
            require_once( IPSLib::getAppDir( 'core' ) . '/sources/classes/attach/class_attach.php' );
            $this->class_attach = new class_attach( $this->registry );
        }

        $this->class_attach->type  = 'post';
        $this->class_attach->init();

        $total = sizeof($this->news);
        $count = 0;

        if($total > 0)
        {
            $to_return = $this->registry->getClass('output')->getTemplate('uportal')->news_attachments_js();

            foreach($this->news as $key=>$fetch)
            {
                $count++;
                $this->lang->words["news{$fetch['tid']}"] = $fetch['title'];

                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_start("news{$fetch['tid']}","news{$fetch['tid']}");

                IPSText::getTextClass('bbcode')->parse_html = ( $this->registry->getClass('class_forums')->forum_by_id[ $fetch['forum_id'] ]['use_html'] and $this->caches['group_cache'][ $fetch['mgroup'] ]['g_dohtml'] and $fetch['post_htmlstate'] ) ? 1 : 0;
                IPSText::getTextClass('bbcode')->parse_nl2br = $fetch['post_htmlstate'] == 2 ? 1 : 0;
                IPSText::getTextClass('bbcode')->parsing_section = 'post';
                IPSText::getTextClass('bbcode')->parsing_mgroup = $this->memberData['member_group_id'];

                if (!$this->memberData['view_img'])
                {
                    $fetch['post'] = IPSText::getTextClass('bbcode')->unconvertSmilies($fetch['post']);
                }

                $fetch['post'] = IPSText::getTextClass('bbcode')->preDisplayParse($fetch['post']);

                if($this->globals['setting']['tease_news'] && $this->globals['setting']['tease_length'] != '')
                {
                    $fetch['post'] = substr($fetch['post'], 0, $this->globals['setting']['tease_length']);
                    $fetch['post'] .= $this->registry->getClass('output')->getTemplate('uportal')->news_view_more($fetch);
                }

                //Handle attachments
                $fetch['attachmentHtml'] = '';
                if($fetch['topic_hasattach'])
                {
                    $this->settings['show_img_upload'] = 1;
                    if(  $this->registry->permissions->check( 'download', $this->registry->getClass('class_forums')->forum_by_id[$fetch['forum_id'] ] ) === false )
                    {
                        $this->settings['show_img_upload'] = 0;
                    }

                    $fetch['post'] = $this->class_attach->renderAttachments( $fetch['post'], array($fetch['pid']) );
                    $fetch['attachmentHtml'] = $fetch['post'][$fetch['pid']]['attachmentHtml'];

                    $fetch['post'] = $fetch['post'][0]['html'];
                }

                $fetch['post_date'] = $this->registry->class_localization->getDate( $fetch['post_date'], 'LONG');

                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->news_block($fetch, $this->globals['setting']['newsforum_height'], $this->globals['setting']['newsforum_height_limit'], $this->globals['setting']['newsforum_width']);
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();

                if($count == $total)
                    $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();
                else
                    $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();
            }
        }

        return $to_return;
    }

    function poll()
    {
        if ($this->globals['setting']['poll']==0)
            return '';
            
        require_once( IPSLib::getAppDir( 'forums' ) . "/sources/classes/forums/class_forums.php" );
        $this->registry->setClass( 'class_forums', new class_forums( $this->registry ) );

        require_once( IPSLib::getAppDir( 'forums' ) . "/sources/classes/topics.php" );
        $this->registry->setClass( 'topics', new app_forums_classes_topics( $this->registry ) );

        require_once( IPSLib::getAppDir( 'forums', 'forums' ) . '/topics.php' );
        $topic = new public_forums_forums_topics();
        $topic->makeRegistryShortcuts( $this->registry );
        
        $topic->forumClass = $this->registry->getClass('class_forums');

        $topic->topic = $this->DB->buildAndFetch( array( 'select' => '*', 'from'   => 'topics', 'where'  => "tid=" . $this->globals['setting']['poll'] ) );
        $topic->forum = ipsRegistry::getClass('class_forums')->forum_by_id[ $topic->topic['forum_id'] ];
        
        $topics = ipsRegistry::getClass('topics');
        $topics->setTopicData($topic->topic);

        $this->request['f'] =  $topic->forum['id'] ;
        $this->request['t'] =  $tid ;

        if ( $topic->topic['poll_state'] )
        {
            $poll_data  = $topic->_generatePollOutput();
            $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start("poll", "poll");
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->general_block($poll_data['html']);
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
            $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

            return $to_return;
        }

        return;
    }

    function top_forums()
    {
        if (!($this->globals['block']['top_forums']))
            return '';

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['top_forums'], "top_forums");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start('header');
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->top_forums_start();

        if(sizeof($this->top_forums) > 0)
        {
            foreach($this->top_forums as $key=>$fetch)
            {
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->top_forums_row($fetch);
            }
        }

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function top_posters()
    {
        if (!($this->globals['block']['top_posters']))
            return '';

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['top_posters'], "top_posters");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start('header');
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->top_posters_start();

        if(sizeof($this->top_posters) > 0)
        {
            foreach($this->top_posters as $key=>$fetch)
            {
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->top_posters_row($fetch);
            }
        }

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function new_members()
    {
        if (!($this->globals['block']['new_members']))
            return '';

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']['new_members'], "new_members");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_start();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_start("header");

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->new_members_start();

        if(sizeof($this->new_members) > 0)
        {
            foreach($this->new_members as $key=>$fetch)
            {
                $fetch['joined'] = $this->registry->class_localization->getDate( $fetch['joined'], 'LONG');
                $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->new_members_row($fetch);
            }
        }

        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->tr_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->table_end();
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    function portal_start()
    {
        return $this->registry->getClass('output')->getTemplate('uportal')->portal_start();
    }

    function portal_end()
    {
        return $this->registry->getClass('output')->getTemplate('uportal')->portal_end();
    }

    function column_start($width="")
    {
        return $this->registry->getClass('output')->getTemplate('uportal')->column_start($width);
    }

    function column_end()
    {
        return $this->registry->getClass('output')->getTemplate('uportal')->column_end();
    }

    function no_content()
    {
        return $this->registry->getClass('output')->getTemplate('uportal')->no_content();
    }

    private function customBlock($block='')
    {
        if (!($this->globals['block']["cb_{$block['id']}"]))
            return '';

        ob_start();
        eval("?>".$block['html']."<?php\n");
        $block['html'] = ob_get_contents();
        ob_end_clean();

        $this->lang->words["cb_{$block['id']}"] = $block['title'];

        $to_return  = $this->registry->getClass('output')->getTemplate('uportal')->block_start($this->globals['block_ids']["cb_{$block['id']}"], "cb_{$block['id']}");
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->custom_block($block['html']);
        $to_return .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();

        return $to_return;
    }

    private function content($contentid, $contentname, $contenttitle, $contenthtml)
    {
        $to_echo = '';

        ob_start();
        eval("?>".$contenthtml."<?php\n");
        $contenthtml = ob_get_contents();
        ob_end_clean();

        switch($this->request['code'])
        {
            case $contentid:
                $this->lang->words[$contentname] = $contenttitle;
                $to_echo .= $this->registry->getClass('output')->getTemplate('uportal')->block_start("cc{$contentid}",$contentname);
                $to_echo .= $this->registry->getClass('output')->getTemplate('uportal')->custom_block($contenthtml);
                $to_echo .= $this->registry->getClass('output')->getTemplate('uportal')->block_end();
                return $to_echo;
                break;
            default:
                break;
        }
    }

    //Helper function that sets the cache if the cache isn't set
    private function checkCache($table_name, $settings_name, $order="")
    {
        if( is_array( $this->registry->cache()->getCache($settings_name) )  == false)
        {
            $cache = array();

            if($order=="")
            {
                $this->DB->build( array(
                    'select'    => '*',
                    'from'      => $table_name
                ));
            }
            else
            {
                $this->DB->build( array(
                    'select'    => '*',
                    'from'      => $table_name,
                    'order'     => $order
                ));
            }

            $query = $this->DB->execute();

            while( $fetch = $this->DB->fetch($query) )
                $cache[] = $fetch;

            $this->registry->cache()->setCache( $settings_name, $cache, array( 'array' => 1, 'deletefirst' => 1, 'donow' => 1 ) );
        }
    }
}
